;   
;
; LCD_INIT 	
;
; SEND_LINE  	/    
; 		:      TBLPTR -      
;
; SEND_CHAR
;
; SEND_CMD
;
; B2_BCD	/  16-    5 
; 		SRDIG_L
; 		:  SRR0,SRR1,SRR2
;
; B2_BCD_M	/  16-    5 
; 		: AARGB0
;	   	AARGB1
; 		:  SRR0,SRR1,SRR2
;
; LCDOUTD1	/      (1   )
; 		       SRR0,SRR1,SRR2
; 		    
;		WREG -  
;
; LCDOUT	/    
; 		       SRR0,SRR1,SRR2
; 		    
;		WREG -  
;
; LCDOUTD2	/      (2   )
; 		       SRR0,SRR1,SRR2
; 		    
;		WREG -  
;

; LCD_CHAR	   
; 		   
; 		WREG -  
; 		   - 0D3
;





LCD_INIT_DELAY	EQU 0
DISP_ON		EQU B'00001110'
CLR_DISP	EQU B'00000001'
ENTRY_INC	EQU B'00000000'
DD_RAM_ADDR	EQU B'10000000'
FUNC_SET	EQU B'00111100'
DISP_OFF	EQU B'00001000'
ENTRY_MODE_SET	EQU B'00000110'






;  LCD  ------------------------------------------------
LCD_INIT	CLRWDT
		CALL LCD_DELAY
		BANKSEL LCD_CNTL
		BCF LCD_CNTL,E
		nop
		nop
		BCF LCD_CNTL,RW
		nop
		nop
		BCF LCD_CNTL,RS
		MOVLW 0x038
		BANKSEL LCD_DATA
		MOVWF LCD_DATA
		nop
		nop
		nop
		BANKSEL LCD_CNTL
		BSF LCD_CNTL,E
		NOP
		nop
		BCF LCD_CNTL,E
		CALL LCD_DELAY

CMD_SEQ		MOVLW 0X038
		BANKSEL LCD_DATA
		MOVWF LCD_DATA
		nop
		nop
		nop
		BANKSEL LCD_CNTL
		BSF LCD_CNTL,E
		NOP
		nop
		BCF LCD_CNTL,E

		MOVLW 0X038
		BANKSEL LCD_DATA
		MOVWF LCD_DATA
		nop
		nop
		BANKSEL LCD_CNTL
		BSF LCD_CNTL,E
		NOP
		nop
		BCF LCD_CNTL,E
		nop
		nop
;		BSF LCD_CNTL,E
		
; Busy Flag should be valid after this point
		MOVLW FUNC_SET
		CALL SEND_CMD
		MOVLW DISP_OFF
		CALL SEND_CMD
		MOVLW DISP_ON
		CALL SEND_CMD
		MOVLW ENTRY_MODE_SET
		CALL SEND_CMD
		RETURN

LCD_DELAY
		BANKSEL MSD			; DELAY = MSD*((3*256)+3)*2*Tcy
		MOVLW LCD_INIT_DELAY		; delay = 256*(3*256+3)*2*0.00000025=0.099
		movlw 2
		MOVWF MSD
		CLRF LSD
LOOP2		DECFSZ LSD,f
		GOTO LOOP2
		CLRWDT
		DECFSZ MSD,f
END_LCD_DELAY	GOTO LOOP2
		RETURN


SEND_CHAR
send_char
		CLRWDT
		BANKSEL CHAR
		MOVWF CHAR
		CALL BUSY_CHECK
		BANKSEL CHAR
		MOVFP CHAR,WREG
		BANKSEL LCD_DATA
		MOVWF LCD_DATA
		nop
		nop
		BANKSEL LCD_CNTL
		BCF LCD_CNTL,RW
		nop
		nop
		BSF LCD_CNTL,RS
		nop
		nop
		BSF LCD_CNTL,E
		NOP
		nop
		nop
		BCF LCD_CNTL,E
		nop
		nop
		nop
		nop
;		BSF LCD_CNTL,E
		RETURN



;     
; WREG - 
SEND_CMD
send_cmd
		CLRWDT
		BANKSEL CHAR
		MOVWF CHAR
		CALL BUSY_CHECK
		BANKSEL CHAR
		MOVFP CHAR,WREG
		BANKSEL LCD_DATA
		MOVWF LCD_DATA
		nop
		nop
		BANKSEL LCD_CNTL
		BCF LCD_CNTL,RW
		nop
		nop
		BCF LCD_CNTL,RS
		nop
		nop
		BSF LCD_CNTL,E
		NOP
		nop
		nop
		BCF LCD_CNTL,E
		nop
		nop
		nop
		nop
;		BSF LCD_CNTL,E
		RETURN

BUSY_CHECK
		banksel LCD_DATA_TRIS
		movlw 0xFF			;     
		movwf LCD_DATA_TRIS
		nop
		nop
		banksel LCD_CNTL		;  
		bcf LCD_CNTL,RS			;   
		nop
		nop
		bsf LCD_CNTL,RW			;   
		nop
		nop
		bsf LCD_CNTL,E			;  
		nop
		nop
		banksel LCD_DATA
		movfp LCD_DATA,WREG		;  
		nop
		nop
		banksel LCD_CNTL		;  
		bcf LCD_CNTL,E
		nop
		nop
		bcf LCD_CNTL,RW
		nop
		nop
		btfsc WREG,7			;    (1-)
		goto BUSY_CHECK
		banksel LCD_DATA_TRIS
		movlw 0x00			;     
		movwf LCD_DATA_TRIS
		return
		


; /    
; :      TBLPTR -      
; :     
SEND_LINE	
		CLRWDT
		BANKSEL TBLPTRL
		TABLRD 1,0,WREG
		TABLRD 0,1,WREG
		CALL SEND_CMD		;     
SEND_LINE3	TABLRD 1,0,WREG		;  
		TABLRD 1,0,WREG		;   ()
		TSTFSZ WREG
		GOTO SEND_LINE1
		RETURN
SEND_LINE1	CALL SEND_CHAR
		TABLRD 0,1,WREG		;   ()
		TSTFSZ WREG
		GOTO SEND_LINE2
		RETURN
SEND_LINE2	CALL SEND_CHAR
		GOTO SEND_LINE3








; /  16-    5 
; : SRDIG_H
;	   SRDIG_L
; :  SRR0,SRR1,SRR2

B2_BCD		
		CLRWDT
		BANKSEL SRCOUNT
		BCF ALUSTA,C		; CLEAR C
		MOVLW .16
		MOVWF SRCOUNT
		CLRF SRR0,1
		CLRF SRR1,1
		CLRF SRR2,1
SRLOOP16	RLCF SRDIG_L,F
		RLCF SRDIG_H,F
		RLCF SRR2,F
		RLCF SRR1,F
		RLCF SRR0,F
		DECFSZ SRCOUNT
		GOTO SRADJDEC
		RETLW 0
SRADJDEC	MOVLW SRR2
		MOVWF FSR0
		CALL SRADJBCD

		MOVLW SRR1
		MOVWF FSR0 
		CALL SRADJBCD

		MOVLW SRR0
		MOVWF FSR0
		CALL SRADJBCD
		GOTO SRLOOP16

SRADJBCD	MOVLW 3
		ADDWF 0,W
		MOVWF SRTEMP
		BTFSC SRTEMP,3		; TEST IF RESULT > 7
		MOVWF 0 
		MOVLW 30
		ADDWF 0,W
		MOVWF SRTEMP
		BTFSC SRTEMP,7
		MOVWF 0
		RETLW 0



; /  16-    5 
; : AARGB0
;	   AARGB1
; :  SRR0,SRR1,SRR2

B2_BCD_M	MOVLR 0
		MOVPF AARGB0,SRDIG_H
		MOVPF AARGB1,SRDIG_L
		CLRWDT
		MOVLR 0
		BCF ALUSTA,C		; CLEAR C
		MOVLW .16
		MOVWF SRCOUNT
		CLRF SRR0,F
		CLRF SRR1,F
		CLRF SRR2,F
SRLOOP16A	RLCF SRDIG_L,F
		RLCF SRDIG_H,F
		RLCF SRR2,F
		RLCF SRR1,F
		RLCF SRR0,F
		DECFSZ SRCOUNT
		GOTO SRADJDECA
		RETLW 0
SRADJDECA	MOVLW SRR2
		MOVWF FSR0
		MOVLW 3
		ADDWF INDF0,W
		MOVWF SRTEMP
		BTFSC SRTEMP,3		; TEST IF RESULT > 7
		MOVWF INDF0 
		MOVLW 30
		ADDWF INDF0,W
		MOVWF SRTEMP
		BTFSC SRTEMP,7
		MOVWF INDF0
;		CALL SRADJBCDA

		MOVLW SRR1
		MOVWF FSR0 
		MOVLW 3
		ADDWF INDF0,W
		MOVWF SRTEMP
		BTFSC SRTEMP,3		; TEST IF RESULT > 7
		MOVWF INDF0 
		MOVLW 30
		ADDWF INDF0,W
		MOVWF SRTEMP
		BTFSC SRTEMP,7
		MOVWF INDF0
;		CALL SRADJBCDA

		MOVLW SRR0
		MOVWF FSR0
		MOVLW 3
		ADDWF INDF0,W
		MOVWF SRTEMP
		BTFSC SRTEMP,3		; TEST IF RESULT > 7
		MOVWF INDF0 
		MOVLW 30
		ADDWF INDF0,W
		MOVWF SRTEMP
		BTFSC SRTEMP,7
		MOVWF INDF0
;		CALL SRADJBCDA
		GOTO SRLOOP16A

;SRADJBCDA	MOVLW 3
;		ADDWF INDF0,W
;		MOVWF SRTEMP
;		BTFSC SRTEMP,3		; TEST IF RESULT > 7
;		MOVWF INDF0 
;		MOVLW 30
;		ADDWF INDF0,W
;		MOVWF SRTEMP
;		BTFSC SRTEMP,7
;		MOVWF INDF0
;		RETLW 0






; /      (1   )
;        SRR0,SRR1,SRR2
;     
;		WREG -  
LCDOUTD1	CLRWDT
		MOVLR 0
		BCF TMP,7			;   0 
		BSF WREG,7
		CALL SEND_CMD

		MOVFP SRR0,WREG
		ANDLW 0X0F
		TSTFSZ WREG
		GOTO LCDOUT10
		MOVLW ' '
		GOTO LCDOUT11
LCDOUT10	ADDLW 0X30
		BSF TMP,7
LCDOUT11	CALL SEND_CHAR

		MOVFP SRR1,WREG
		ANDLW 0XF0
		SWAPF WREG,W
		TSTFSZ WREG
		GOTO LCDOUT12
		BTFSC TMP,7
		GOTO LCDOUT12
		MOVLW ' '
		GOTO LCDOUT13
LCDOUT12	ADDLW 0X30
		BSF TMP,7
LCDOUT13	CALL SEND_CHAR

		MOVFP SRR1,WREG
		ANDLW 0X0F
		TSTFSZ WREG
		GOTO LCDOUT14
		BTFSC TMP,7
		GOTO LCDOUT14
		MOVLW ' '
		GOTO LCDOUT15
LCDOUT14	ADDLW 0X30
		BSF TMP,7
LCDOUT15	CALL SEND_CHAR
		
		MOVFP SRR2,WREG
		ANDLW 0XF0
		SWAPF WREG,W
		ADDLW 0X30
		CALL SEND_CHAR

		MOVLW ','
		CALL SEND_CHAR

		MOVFP SRR2,WREG
		ANDLW 0X0F
		ADDLW 0X30
		CALL SEND_CHAR

		RETURN


; /      (2   )
;        SRR0,SRR1,SRR2
;     
;		WREG -  
LCDOUTD2	CLRWDT
		MOVLR 0
		BCF TMP,7			;   0 
		BSF WREG,7
		CALL SEND_CMD

		MOVFP SRR0,WREG
		ANDLW 0x0F
		TSTFSZ WREG
		GOTO LCDOUT101
		MOVLW ' '
		GOTO LCDOUT111
LCDOUT101	ADDLW 0x30
		BSF TMP,7
LCDOUT111	CALL SEND_CHAR

		MOVFP SRR1,WREG
		ANDLW 0xF0
		SWAPF WREG,W
		TSTFSZ WREG
		GOTO LCDOUT121
		BTFSC TMP,7
		GOTO LCDOUT121
		MOVLW ' '
		GOTO LCDOUT131
LCDOUT121	ADDLW 0x30
		BSF TMP,7
LCDOUT131	CALL SEND_CHAR

		MOVLR 0
		MOVFP SRR1,WREG
		ANDLW 0x0F
		ADDLW 0x30
		CALL SEND_CHAR

		MOVLW ','
		CALL SEND_CHAR
		
		MOVLR 0
		MOVFP SRR2,WREG
		ANDLW 0xF0
		SWAPF WREG,W
		ADDLW 0x30
		CALL SEND_CHAR

		MOVLR 0
		MOVFP SRR2,WREG
		ANDLW 0x0F
		ADDLW 0x30
		CALL SEND_CHAR
		RETURN




; /    
;        SRR0,SRR1,SRR2
;     
;		WREG -  
LCDOUT		CLRWDT
		MOVLR 0
		BCF TMP,7		;   0
		BSF WREG,7
		CALL SEND_CMD

		MOVLR 0
		MOVFP SRR0,WREG
		ANDLW 0x0F
		TSTFSZ WREG
		GOTO LCDOUT_1
		MOVLW ' '
		GOTO LCDOUT_2
LCDOUT_1	ADDLW 0x30
		BSF TMP,7
LCDOUT_2	CALL SEND_CHAR


		MOVLR 0
		MOVFP SRR1,WREG
		ANDLW 0XF0
		SWAPF WREG,W
		BTFSC TMP,7
		GOTO LCDOUT_3
		TSTFSZ WREG
		GOTO LCDOUT_3
		MOVLW ' '
		GOTO LCDOUT_4
LCDOUT_3	ADDLW 0X30
		BSF TMP,7
LCDOUT_4	CALL SEND_CHAR


		MOVLR 0
		MOVFP SRR1,WREG
		ANDLW 0X0F
		BTFSC TMP,7
		GOTO LCDOUT_5
		TSTFSZ WREG
		GOTO LCDOUT_5
		MOVLW ' '
		GOTO LCDOUT_6
LCDOUT_5	ADDLW 0X30
		BSF TMP,7
LCDOUT_6	CALL SEND_CHAR
		
		MOVFP SRR2,WREG
		ANDLW 0XF0
		SWAPF WREG,W
		BTFSC TMP,7
		GOTO LCDOUT_7
		TSTFSZ WREG
		GOTO LCDOUT_7
		MOVLW ' '
		GOTO LCDOUT_8
LCDOUT_7	ADDLW 0X30
		BSF TMP,7
LCDOUT_8	CALL SEND_CHAR

		MOVFP SRR2,WREG
		ANDLW 0X0F
		ADDLW 0X30
		CALL SEND_CHAR
		RETURN



;    
;    
; WREG -  
;    - 0D3


LCD_CHAR
		MOVLR 0
		MOVWF TMP
		MOVLW 0xD3
		CALL SEND_CMD
		MOVLR 0
		MOVFP TMP,WREG
		CALL SEND_CHAR
		RETURN



